package gov.va.med.mhv.health.web.validator;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

/*
 * valid patterns are
 * (443) 289-3469   (999) 999-9999 or (999)999-9999
 * 890.000.8090     999.999.9999
 * 100-100-1000     999-999-9999
 * 123456789012		12 digits
 * 4564646465       10 digits
 * 
 * note: can have leading and trailing spaces
 * in future, if you didn't want that change it to "^{pattern}$" instead of " *{pattern} *"
 */
@FacesValidator(value="AllergyValidator")
public class AllergyValidator implements Validator {
	@Override
	public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
		
		String LabelField="";
		
		LabelField = component.getId();
		UIViewRoot viewRoot = FacesContext.getCurrentInstance().getViewRoot();
		 //component = viewRoot.findComponent("medicalevent");
		 
		 if (LabelField.equalsIgnoreCase("medicalevent")){
			 LabelField = "Medical Event"; 
		 }

		 if (LabelField.equalsIgnoreCase("allery")){
			 LabelField = "Allery"; 
		 }

		
		String allery = (String) value;
				
		if (allery == null || allery.isEmpty()) {
			return; // Let required="true" or @NotNull handle it.
		}
		
		if (allery.length() < 2) {
			String summary = String.format(" The %s value must be at least 2 characters long.", LabelField);
			String detail = "Enter a value that is at least 2 characters long.";
			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, detail));
		}
	}

}
